#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Model PastelMod01.fsh   by Kali   
//https://www.shadertoy.com/view/7ltfRB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float det=.001;
vec3 pos;

mat2 rot(float a){
    float s=sin(a),c=cos(a);
    return mat2(c,s,-s,c);
}

float de(vec3 p) {
    p*=1.2-length(sin(p+iTime))*.25;
    p.xz*=rot(iTime+p.y*.5);
    p.yz*=rot(iTime+p.x*.5);
    pos=p;
    float d=length(p)-3.;
    d=max(d,-length(p)+2.5);
    vec3 s=sin(p*3.);
    d+=length(s*s)*.27;
    d=min(d,length(p)-1.5);
    return d*.4;
}

vec3 normal(vec3 p) {
    vec2 e=vec2(0.,det*2.);
    return normalize(vec3(de(p+e.yxx),de(p+e.xyx),de(p+e.xxy))-de(p));
}

vec3 shade(vec3 p, vec3 dir, vec3 n) {
    vec3 ldir=normalize(vec3(1.,1.,-1.));
    float amb=.15;
    float dif=max(0.,dot(ldir,n))*.9;
    vec3 col=abs(mix(sin(pos),cos(pos),pos.x*.5));
    return (amb+dif)*col;
    
}

vec3 march(vec3 from, vec3 dir) {
    float td=0.,d=0.,ref=0.,maxdist=45.;
    vec3 col=vec3(0.),colref=col,p=from;
    for(int i=0; i<150; i++){
        p+=d*dir;
        d=de(p);
        if (d<det&&ref>0.||td>maxdist) break;
        if (d<det&&ref<1.&&(length(fract(pos)-.5)<.6||length(pos)>1.6)) {
            ref=1.;
            vec3 n=normal(p);
            colref+=shade(p,dir,n);
            dir=reflect(dir,n);
            p+=dir*.1;
        }
        td+=d;
    }
    if (d>det) {
        td=maxdist;
        p=dir*maxdist;
        col+=smoothstep(.15,.0,abs(fract(p.y*.1)-.5))*.5;
        col+=smoothstep(.15,.0,abs(fract(p.x*.1)-.5))*.5;
    } else {
        vec3 n=normal(p);
        col=shade(p,dir,n);
    }
    col=mix(col,colref,ref*.7);
    col=mix(col,vec3(1.),td/maxdist*.3);
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-iResolution.xy*.5)/iResolution.y;
    vec2 uv2 = fragCoord/iResolution.xy-.5;

    vec3 from=vec3(0.,0.,-8.);
    vec3 dir=normalize(vec3(uv,1.));
    from.xz*=rot(iTime*.3-2.);
    dir.xz*=rot(iTime*.3-2.);
    
    vec3 col = march(from,dir);
    col*=smoothstep(.5,.1,abs(uv2.x));
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

